﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mdws2ORM
{
    public class ListParam
    {
        public ListParam(
            string from,
            string number,
            string screen,
            string flags,
            string partial,
            string identity,
            string index)
        {
            if (from == null)
                throw new ArgumentNullException();
            if (number == null)
                throw new ArgumentNullException();
            if (screen == null)
                throw new ArgumentNullException();
            if (flags == null)
                throw new ArgumentNullException();
            if (partial == null)
                throw new ArgumentNullException();
            if (identity == null)
                throw new ArgumentNullException();
            if (index == null)
                throw new ArgumentNullException();

            From = from;
            Number = number;
            Screen = screen;
            Flags = flags;
            Partial = partial;
            Identity = identity;
            Index = index;
        }

        public readonly string From;
        public readonly string Number;
        public readonly string Screen;
        public readonly string Flags;
        public readonly string Partial;
        public readonly string Identity;
        public readonly string Index;

        private static void Append(StringBuilder sb, string name, string value)
        {
            if (string.IsNullOrEmpty(value)) return;
            sb.Append(name);
            sb.Append('=');
            sb.Append(value);
            sb.Append(';');
        }

        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            Append(sb, "From", From);
            Append(sb, "Number", Number);
            Append(sb, "Screen", Screen);
            Append(sb, "Flags", Flags);
            Append(sb, "Partial", Partial);
            Append(sb, "Identity", Identity);
            Append(sb, "Index", Index);

            return sb.ToString();
        }
    }
}
